<?php
require_once 'config.php';

header('Content-Type: application/json');

$moduleCode = $_GET['module_code'] ?? '';

$history = [];

if (!empty($moduleCode)) {
    $stmt = $conn->prepare("SELECT module_code, batch_date, batch_week_code, batch_number, start_sequence, quantity, end_sequence, file_name, created_at FROM batch_records WHERE module_code = ? ORDER BY created_at DESC");
    $stmt->bind_param("s", $moduleCode);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $history[] = $row;
    }
    $stmt->close();
}

$conn->close();

echo json_encode($history);
?> 