<?php
require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_GET['module_code'])) {
    echo json_encode(['error' => '缺少模块代码']);
    exit;
}

$moduleCode = $_GET['module_code'];

// 获取最新的批次号
$stmt = $conn->prepare("SELECT batch_number FROM batch_records WHERE module_code = ? AND LEFT(batch_week_code, 2) = RIGHT(YEAR(CURDATE()), 2) ORDER BY batch_number DESC limit 1");
$stmt->bind_param("s", $moduleCode);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

$batchNumber = $row['batch_number'] ? $row['batch_number'] + 1 : 1;

echo json_encode(['batch_number' => $batchNumber]);
?> 